% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.bam.specification.R
\name{prepare.bam.specification}
\alias{prepare.bam.specification}
\title{Prepare BAM specification data frame to standardized format for downstream analyses.}
\usage{
prepare.bam.specification(sample.details, paired = TRUE,
  sample.id.column = 1, tumour.bam.column = 2, normal.bam.column = 3)
}
\arguments{
\item{sample.details}{Data frame where each row represents a sample to be run. 
Must contain sample ID, path to tumour BAM, and path to normal BAM.}

\item{paired}{Logical indicating whether the sample specification is for a paired analysis.}

\item{sample.id.column}{Index or string giving column of sample.details that contains the sample ID}

\item{tumour.bam.column}{Index or string giving column of sample.details that contains the path to the tumour BAM}

\item{normal.bam.column}{Index or string giving column of sample.details that contains the path to the normal BAM}
}
\value{
bam.specification Data frame with one row per sample to be run
}
\description{
This function prepares a data frame that can be used to run variant callers. 
For matched normal variant calling, this data frame will contain three columns with names: sample.id, tumour.bam, normal.bam
For unpaired variant calling, the data frame will contain two columns with names: sample.id, tumour.bam
}
