% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bodyfat.R
\docType{data}
\name{bodyfat}
\alias{bodyfat}
\title{Percentage of body fat data set}
\format{
A data-frame with 298 observations and 9 columns:

\itemize{
\item \code{ARMS}: arms fat percentage.
\item \code{LEGS}: legs fat percentage.
\item \code{BODY}: body fat percentage.
\item \code{ANDROID}: android fat percentage.
\item \code{GYNECOID}: ginecoid fat percentage.
\item \code{AGE}: age of individuals.
\item \code{BMI}: body mass index.
\item \code{SEX}: 1 for female, 2 for male.
\item \code{IPAQ}: 0 for IPAQ = sedentary, 1 for IPAQ = insufficiently active and 2 for IPAQ = active.
}
}
\source{
\url{http://www.leg.ufpr.br/doku.php/publications:papercompanions:multquasibeta}
}
\usage{
data(bodyfat, package = "vasicekreg")
}
\description{
The body fat percentage of individuals assisted in a public hospital in Curitiba, Paraná, Brazil.
}
\examples{
data(bodyfat, package = "vasicekreg")

bodyfat$BMI <- bodyfat$BMI / 100
bodyfat$SEX <- as.factor(bodyfat$SEX)
bodyfat$IPAQ<- as.factor(bodyfat$IPAQ)

library(gamlss)

# mean fit 
fitmean.logit <- gamlss(ARMS ~ AGE + BMI + SEX + IPAQ, 
data = bodyfat, family = VASIM(mu.link = "logit", sigma.link = "logit"))

fitmean.probit <- gamlss(ARMS ~ AGE + BMI + SEX + IPAQ, 
data = bodyfat, family = VASIM(mu.link = "probit", sigma.link = "logit"))

# quantile fit - tau = 0.5

tau <- 0.50
fitquant.logit <- gamlss(ARMS ~ AGE + BMI + SEX + IPAQ, data = bodyfat,
family = VASIQ(mu.link = "logit", sigma.link = "logit"))

fittaus <- lapply(c(0.10, 0.25, 0.50, 0.75, 0.90), function(Tau)
{
 tau <<- Tau; 
 gamlss(ARMS ~ AGE + BMI + SEX + IPAQ, data = bodyfat,
 family = VASIQ(mu.link = "logit", sigma.link = "logit"))
})

sapply(fittaus, summary, USE.NAMES = TRUE)
}
\references{
Mazucheli, J., Leiva, V., Alves, B., and Menezes A. F. B., (2021). A new quantile regression for modeling bounded data under a unit Birnbaum-Saunders distribution with applications in medicine and politics. \emph{Symmetry}, \bold{13}(4) 1--21.

Petterle, R. R., Bonat, W. H., Scarpin, C. T., Jonasson, T., and Borba, V. Z. C., (2020). Multivariate quasi-beta regression models for continuous bounded data. \emph{The International Journal of Biostatistics}, 1--15, (preprint).
}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Bruna Alves \email{pg402900@uem.br}
}
\keyword{datasets}
