% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcfR-package.R, R/vcfR.R
\docType{package}
\name{vcfR-package}
\alias{vcfR}
\alias{vcfR-package}
\title{vcfR: Manipulate and Visualize VCF Data}
\description{
Facilitates easy manipulation of variant call format (VCF) data. Functions are provided to rapidly read from and write to VCF files. Once VCF data is read into R a parser function extracts matrices of data. This information can then be used for quality control or other purposes. Additional functions provide visualization of genomic data. Once processing is complete data may be written to a VCF file (*.vcf.gz). It also may be converted into other popular R objects (e.g., genlight, DNAbin). VcfR provides a link between VCF data and familiar R software.

vcfR provides a suite of tools for input and output of variant call format (VCF) files, manipulation of their content and visualization.
}
\details{
\strong{File input and output} is facilitated with the functions \code{read.vcfR} and \code{write.vcf}.
Input of vcf format data results in an S4 \code{\link{vcfR-class}} object.
Objects of class vcfR can be manipulated with \link[vcfR:vcfR-method]{vcfR-method} and \code{extract.gt}.
Contents of the vcfR object can be visualized with the \code{\link{plot}} method.
More complex visualizations can be created using a series of functions.
See \code{vignette(topic="sequence_coverage")} for an example.
Once manipulations are complete the object may be written to a *.vcf.gz format file using \code{write.vcf} or exported to objects supported by other R packages with \code{vcfR2genind} or \code{vcfR2loci}.


More complex visualization can be accomplished by converting a vcfR object to a \code{\link{chromR-class}} object.
An example exists on the \code{create.chromR} man page.



A \strong{complete list of functions} can be displayed with: library(help = vcfR).

\strong{Vignettes} (documentation) can be listed with: \code{browseVignettes('vcfR')}.


Several example \strong{datasets} are included in vcfR.
\strong{vcfR_test} comes from the VCF specification and provides a vcfR object with a diversity of examples in a small dataset.
\strong{vcfR_example} is a subset of the pinfsc50 dataset that includes VCF, GFF and FASTA data for moderate sized testing.
The \href{https://cran.r-project.org/package=pinfsc50}{pinfsc50} dataset is available as a separate package and includes VCF, GFF and FASTA data for testing and benchmarking.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/knausb/vcfR}
  \item \url{https://knausb.github.io/vcfR_documentation/}
}


More documentation for vcfR can be found at the \href{https://knausb.github.io/vcfR_documentation/}{vcfR documentation} website.
}
\author{
\strong{Maintainer}: Brian J. Knaus \email{briank.lists@gmail.com} (\href{https://orcid.org/0000-0003-1665-4343}{ORCID})

Authors:
\itemize{
  \item Niklaus J. Grunwald \email{grunwaln@science.oregonstate.edu} (\href{https://orcid.org/0000-0003-1656-7602}{ORCID})
}

Other contributors:
\itemize{
  \item Eric C. Anderson \email{eric.anderson@noaa.gov} (\href{https://orcid.org/0000-0003-1326-0840}{ORCID}) [contributor]
  \item David J. Winter \email{david.winter@gmail.com} [contributor]
  \item Zhian N. Kamvar \email{zkamvar@gmail.com} (\href{https://orcid.org/0000-0003-1458-7108}{ORCID}) [contributor]
  \item Javier F. Tabima \email{caifaz01@gmail.com} (\href{https://orcid.org/0000-0002-3603-2691}{ORCID}) [contributor]
}

}
\keyword{internal}
