% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis.r
\encoding{UTF-8}
\name{axis_y}
\alias{axis_y}
\title{General axis setttings (y-axis)}
\usage{
axis_y(vl, axisWidth = NULL, layer = NULL, offset = NULL, grid = NULL,
  labels = TRUE, labelAngle = NULL, labelAlign = NULL,
  labelBaseline = NULL, labelMaxLength = 25, shortTimeLabels = NULL,
  subdivide = NULL, ticks = NULL, tickPadding = NULL, tickSize = NULL,
  tickSizeMajor = NULL, tickSizeMinor = NULL, tickSizeEnd = NULL,
  title = "", titleOffset = NULL, titleMaxLength = NULL,
  characterWidth = 6, orient = NULL, format = NULL, remove = FALSE)
}
\arguments{
\item{vl}{Vega-Lite object}

\item{axisWidth, layer, offset, grid, labels, labelAngle, labelAlign, labelBaseline}{see \href{http://vega.github.io/vega-lite/docs/axis.html}{axis docs} &
\href{https://github.com/vega/vega-lite/blob/master/src/axis.ts}{axis base config}}

\item{labelMaxLength, shortTimeLabels, subdivide, ticks, tickPadding, tickSize}{see \href{http://vega.github.io/vega-lite/docs/axis.html}{axis docs} &
\href{https://github.com/vega/vega-lite/blob/master/src/axis.ts}{axis base config}}

\item{tickSizeMajor, tickSizeMinor, tickSizeEnd, title, titleOffset, titleMaxLength}{see \href{http://vega.github.io/vega-lite/docs/axis.html}{axis docs} &
\href{https://github.com/vega/vega-lite/blob/master/src/axis.ts}{axis base config}}

\item{characterWidth, orient, format, remove}{see \href{http://vega.github.io/vega-lite/docs/axis.html}{axis docs} &
\href{https://github.com/vega/vega-lite/blob/master/src/axis.ts}{axis base config}}
}
\description{
Axes provide axis lines, ticks and labels to convey how a spatial range represents
a data range. Simply put, axes visualize scales. \cr
\cr
By default, Vega-Lite automatically creates axes for x, y, row, and column channels
when they are encoded. Axis can be customized via the axis property of a channel
definition.
}
\examples{
vegalite() \%>\%
  add_data("https://vega.github.io/vega-editor/app/data/population.json") \%>\%
  add_filter("datum.year == 2000") \%>\%
  calculate("gender", 'datum.sex == 2 ? "Female" : "Male"') \%>\%
  encode_x("gender", "nominal") \%>\%
  encode_y("people", "quantitative", aggregate="sum") \%>\%
  encode_color("gender", "nominal") \%>\%
  scale_x_ordinal(band_size=6) \%>\%
  scale_color_nominal(range=c("#EA98D2", "#659CCA")) \%>\%
  facet_col("age", "ordinal", padding=4) \%>\%
  axis_x(remove=TRUE) \%>\%
  axis_y(title="population", grid=FALSE) \%>\%
  axis_facet_col(orient="bottom", axisWidth=1, offset=-8) \%>\%
  facet_cell(stroke_width=0) \%>\%
  mark_bar()
}
\references{
\href{http://vega.github.io/vega-lite/docs/axis.html}{Vega-List Axis spec}
}

