% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark.r
\encoding{UTF-8}
\name{mark_text}
\alias{mark_text}
\title{Text mark}
\usage{
mark_text(vl, opacity = NULL, color = NULL, fill = NULL, stroke = NULL)
}
\arguments{
\item{vl}{a Vega-Lite object}

\item{opacity}{\code{0.0}-\code{1.0}}

\item{color}{color of the mark – either fill or stroke color based on the filled mark config.}

\item{fill}{fill color. This config will be overridden by color channel’s
specified or mapped values if filled is true.}

\item{stroke}{stroke color. This config will be overridden by color channel’s
specified or mapped values if filled is false.}
}
\description{
A text mark represents each data point with a text instead of a point.
}
\examples{
vegalite() \%>\%
  cell_size(300, 200) \%>\%
  add_data("https://vega.github.io/vega-editor/app/data/cars.json") \%>\%
  encode_x("Horsepower", "quantitative") \%>\%
  encode_y("Miles_per_Gallon", "quantitative") \%>\%
  encode_color("Origin", "nominal") \%>\%
  calculate("OriginInitial", "datum.Origin[0]") \%>\%
  encode_text("OriginInitial", "nominal") \%>\%
  mark_text()
}
\references{
\href{http://vega.github.io/vega-lite/docs/mark.html}{Vega-Lite Mark spec}
}

