% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadPaleogeography.R
\name{downloadPaleogeography}
\alias{downloadPaleogeography}
\title{Downloads paleogeographic maps}
\usage{
downloadPaleogeography(Age = 0)
}
\arguments{
\item{Age}{A whole number up to 550}
}
\value{
A simple features object
}
\description{
Download a paleogeographic map for an age expressed in millions of years ago.
}
\details{
Downloads a map of paleocontinents for a specific age from Macrostrat.org as a shapefile. The given age must be expressed as a whole number. Note that the function makes use of the rgdal and RCurl packages.
}
\examples{

# Download a test dataset of Maastrichtian bivalves.
# DataPBDB<-downloadPBDB(Taxa="Bivalvia",StartInterval="Maastrichtian",StopInterval="Maastrichtian")

# Download a paleogeographic map.
# KTBoundary<-downloadPaleogeography(Age=66)

# Plot the paleogeographic map (uses rgdal) and the PBDB points.
# plot(KTBoundary,col="grey")
# points(x=DataPBDB[,"paleolng"],y=DataPBDB[,"paleolat"],pch=16,cex=2)

}
\author{
Andrew A. Zaffos
}
