% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAI.values.R
\name{CAI.values}
\alias{CAI.values}
\title{Codon Adaptation  Index  (CAI)}
\usage{
CAI.values(df.virus, ENc.set.host,
                       df.host,genetic.code = "1",set.len = 5, threshold = 0)
}
\arguments{
\item{df.virus}{a data frame with seq_name and its virus DNA sequence.}

\item{ENc.set.host}{a data frame with ENc values of a host.}

\item{df.host}{a data frame with seq_name and its host DNA sequence.}

\item{genetic.code}{a single string that uniquely identifies a genetic code to use.}

\item{set.len}{a number represents a percent that will be used as reference genes from the total host genes.}

\item{threshold}{optional numeric, specifying sequence length, in codons, used for filtering.}
}
\value{
A data.frame containing the computed CAI values for each DNA sequences within df.fasta.
}
\description{
Measure the Codon Adaptation  Index  (CAI)  Sharp  and  Li  (1987), of DNA sequence.
}
\details{
For more information about CAI \href{https://academic.oup.com/nar/article-abstract/15/3/1281/1166844?redirectedFrom=fulltext}{Sharp  and  Li, 1987}.
}
\examples{

\dontshow{
file_path <- system.file("extdata", "sysdata.RData" ,package = "vhcub")
load(file = file_path)
}
\donttest{
# read DNA from fasta file
fasta <- fasta.read("virus.fasta", "host.fasta")
fasta.v <- fasta[[1]]
fasta.h <- fasta[[2]]
# Calculate CAI
enc.df.host <- ENc.values(fasta.h) 
}
\dontshow{fasta.v <- fasta.v[1:10,]}
cai.df <- CAI.values(fasta.v, enc.df.host, fasta.h)


}
\author{
Ali Mostafa Anwar \email{ali.mo.anwar@std.agr.cu.edu.eg} and Mohmed Soudy \email{MohmedSoudy2009@gmail.com}
}
