% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCUO.values.R
\name{SCUO.values}
\alias{SCUO.values}
\title{Synonymous codon usage eorderliness (SCUO)}
\usage{
SCUO.values(df.fasta,genetic.code = "1",threshold=0)
}
\arguments{
\item{df.fasta}{a data frame with seq_name and its DNA sequence.}

\item{genetic.code}{a single string that uniquely identifies a genetic code to use.}

\item{threshold}{optional numeric, specifying sequence length, in codons, used for filtering.}
}
\value{
A data.frame containing the computed SCUO values for each DNA sequences within df.fasta.
}
\description{
Measure the Synonymous Codon Usage Eorderliness (SCUO) of DNA sequence (Wan et al., 2004).
}
\details{
For more information about ENc \href{https://bmcevolbiol.biomedcentral.com/articles/10.1186/1471-2148-4-19}{Wan et al., 2004}.
}
\examples{
\dontshow{
file_path <- system.file("extdata", "sysdata.RData" ,package = "vhcub")
load(file = file_path)
}

\donttest{
# read DNA from fasta file
fasta <- fasta.read("virus.fasta", "host.fasta")
fasta.v <- fasta[[1]]
fasta.h <- fasta[[2]]
}
# Calculate SCUO
\dontshow{fasta.v <- fasta.v[1:10,]}
SCUO.df <- SCUO.values(fasta.v)

}
\author{
Ali Mostafa Anwar \email{ali.mo.anwar@std.agr.cu.edu.eg} and Mohmed Soudy \email{MohmedSoudy2009@gmail.com}
}
