% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visNetworkEditor.R
\name{visNetworkEditor}
\alias{visNetworkEditor}
\title{Visualize, customize and get back a \code{visNetwork} object. Need shiny package}
\usage{
visNetworkEditor(object, filter = NULL, showButton = NULL)
}
\arguments{
\item{object}{: a \code{visNetwork} object}

\item{filter}{: see  \link[visNetwork]{visConfigure}}

\item{showButton}{: see  \link[visNetwork]{visConfigure}}
}
\value{
a \code{visNetwork} object
}
\description{
Visualize, customize and get back a \code{visNetwork} object. Need shiny package
}
\examples{

\dontrun{

nodes <- data.frame(id = 1:3, label = paste("Node", 1:3))
edges <- data.frame(from = c(1,2), to = c(1,3), label = paste("Edge", 1:2))
network <- visNetwork(nodes, edges)

custom_network <- visNetworkEditor(object = network)
custom_network

custom_network <- visNetworkEditor(object = network, filter = "nodes,edges")
custom_network

}

}
\references{
See online documentation \url{https://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link[visNetwork]{visConfigure},  \link[visNetwork]{visTree},  \link[visNetwork]{visNetworkEditorServer}
}
