% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_minmax.R
\name{plot_minmax}
\alias{plot_minmax}
\title{Generate individual subplots within the graphical visualization}
\usage{
plot_minmax(My, X, Y, str, color.type, alpha, add.p.axis, add.h.axis,
  cond.tree, text.main, text.bar, text.round, text.percentile,
  density.line, text.title, text.axis, text.label)
}
\arguments{
\item{My}{A matrix to define the split points within the decision tree structure}

\item{X}{Covariates}

\item{Y}{Response variable}

\item{str}{Structure of pathway from the root node in the decision tree to each terminal node}

\item{color.type}{Color palettes. (rainbow_hcl = 1; heat_hcl = 2; terrain_hcl = 3; sequential_hcl = 4; diverge_hcl = 5)}

\item{alpha}{Transparency of individual horizontal bars. Choose values between 0 to 1.}

\item{add.p.axis}{logical. Add axis for the percentiles (add.p.axis = TRUE), remove axis for the percentiles (add.p.axis = FALSE).}

\item{add.h.axis}{logical. Add axis for the outcome (add.h.axis = TRUE), remove axis for the outcome (add.h.axis = FALSE).}

\item{cond.tree}{Tree as a party object}

\item{text.main}{Change the size of the main titles}

\item{text.bar}{Change the size of the text in the horizontal bar and below the bar plot}

\item{text.round}{Round the threshold displayed on the bar}

\item{text.percentile}{Change the size of the percentile title}

\item{density.line}{Draw a density line}

\item{text.title}{Change the size of the text in the title}

\item{text.axis}{Change the size of the text of axis labels}

\item{text.label}{Change the size of the axis annotation}
}
\description{
This function is utilized to generate a series of sub-plots, where each subplot corresponds to individual terminal nodes within the decision tree structure. Each subplot is composed of a histogram (or a barchart) that displays the distribution for the relevant subgroup and colored horizontal bars that summarize the set of covariate splits.
}
\keyword{decision}
\keyword{matrix}
\keyword{pathway}
\keyword{tree}
