% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denscomp.R
\name{denscomp}
\alias{denscomp}
\title{Components Density Plot}
\usage{
denscomp(
  model,
  sep = "+",
  combination,
  violin = FALSE,
  random = TRUE,
  z_value = FALSE
)
}
\arguments{
\item{model}{An object of class \code{\link[netmeta]{netmeta}}.}

\item{sep}{A single character that defines the separator between interventions components.}

\item{combination}{A character vector that contains the component combinations of interest.}

\item{violin}{\code{logical}. If \code{TRUE} the density is visualized via violins instead of density plots.}

\item{random}{\code{logical}. If \code{TRUE} the random-effects NMA model is used, instead of the fixed-effect NMA model.}

\item{z_value}{\code{logical}. If \code{TRUE} z-values are used, instead intervention effects.}
}
\value{
An object of class \code{ggplot}.
}
\description{
The function creates density plots in order to explore the efficacy of the components.
}
\details{
If the length of the argument \code{combination} is 1, the function creates two density plots. The first is produced based on the
interventions that include the component combination of interest (which is specified by the argument \code{combination}),
while the second on the interventions that do not include the underlying component combination.

If the argument \code{combination} includes more than one elements, the number of densities is equal with the length of
the argument \code{combination}, and each density is based on the interventions that include the relative component combination.
For example, if \code{combination = c("A + B", "B + C", "A")} the function will produce 3 density plots that are based on
the interventions that includes components \code{"A"} and \code{"B"}, the interventions that include components \code{"B"} and \code{"C"} and
interventions that includes component \code{"A"}, respectively.

The function by default uses the intervention's relative effects (\code{z_value = FALSE}) obtained from the random-effects network
meta-analysis (NMA) model (\code{random = TRUE}). It can be also adjusted to use the intervention's z-values
instead of the relative effects, by setting \code{z_value = TRUE}.
}
\note{
The efficacy of the components could be explored via violins plots instead of density plots, by setting \code{violin = TRUE}.
Also, in the case of dichotomous outcomes, the log-scale is used.

The function can be applied only in network meta-analysis models that contain multi-component interventions.
}
\examples{
data(nmaMACE)
denscomp(model = nmaMACE, combination = "C")

}
