% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDimensions.R
\name{getDimensions}
\alias{getDimensions}
\title{Get Dimensions}
\usage{
getDimensions(
  path = ".",
  audioList = list(),
  fileType = "wav",
  fileNamePattern = "ID_Condition_Dimension",
  sep = "_",
  filter = NULL,
  recursive = FALSE
)
}
\arguments{
\item{path}{A character string indicating the path to the folder containing the audio files. Default corresponds to the current working directory.}

\item{audioList}{Optional list with Wave objects to analyze.}

\item{fileType}{Character string indicating the file format (wav or mp3) of the audio files. Default corresponds to wav.}

\item{fileNamePattern}{cCharacter string indicating the naming format of the audio files, such as "ID-Condition-Dimension", "Condition_ID_Dimension" or "ID". Default corresponds to "ID_Condition_Dimension".}

\item{sep}{A non alpha-numeric that acts as separator between the different naming components. Default corresponds to underscore.}

\item{filter}{Optional character vector to filter for specific audio files. Default corresponds to NULL.}

\item{recursive}{A logical value indicating whether subdirectories should be included when searching for voice files. Default corresponds to FALSE.}
}
\value{
Character vector, which contains all the unique dimensions of the voice files found in the specified directory.
}
\description{
Retrieves the unique dimensions from the file name of multiple audio files following a naming pattern in which the various components (IDs, dimensions and, conditions) are separated by a non-alphanumeric character.
}
\examples{
getDimensions(audioList = testAudioList,
fileNamePattern = "ID_Condition_Dimension", sep = "_")

}
