% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaV.R
\name{deltaV}
\alias{deltaV}
\title{Approximate potential difference between two points}
\usage{
deltaV(f, x, x0, normType = "f")
}
\arguments{
\item{f}{Flow equations (right hand side of differential equation)}

\item{x}{Position where we want to know the approximate potential}

\item{x0}{Reference position (center of the Taylor expansion)}

\item{normType}{(default: 'f') Matrix norm used to compute the error}
}
\value{
A list containing the approximate potential difference between x and x0 and the estimated error
}
\description{
Approximate potential difference between two points
}
\examples{
# One dimensional flow
f <- function(x) { cos(x) }

# Evaluation points
x0 <- 1
x1 <- 1.02

dV <- deltaV(f, x1, x0)

 # Two dimensional flow
f <- function(x) { c(
 -2*x[1]*x[2],
 -x[1]^2 - 1
)}

# Evaluation points
x0 <- matrix(c(1,2), ncol = 1)
x1 <- matrix(c(0.98,2.01), ncol = 1)

dV <- deltaV(f, x1, x0)
}
\references{
\url{https://arxiv.org/abs/1903.05615}
}
\seealso{
\code{\link{approxPot1D}, \link{approxPot2D}, \link{norm}}
}
\author{
Pablo Rodríguez-Sánchez (\url{https://pabrod.github.io})
}
