% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rconfusionmatrix.R
\name{rconfusionmatrix}
\alias{rconfusionmatrix}
\title{Redistributed confusion matrix}
\usage{
rconfusionmatrix(m, custom.weights = NA,
                        print.weighted.accuracy = FALSE)
}
\arguments{
\item{m}{the caret confusion matrix object or simple matrix.}

\item{custom.weights}{the vector of custom weights to be applied, which
should be equal to "n", but can be larger, with excess values, as well as
the first element, being ignored. The first element is ignored because it
represents weighting applied to the diagonal. As, in the case of
redistribution, a proportion of the non-diagonal observations is shifted
towards the diagonal, the weighting applied to the diagonal depends on the
weights assigned to the non-diagonal elements, and is thus not configurable
by the user.}

\item{print.weighted.accuracy}{print the standard accuracy metric for the
redistributed matrix, which represents the sum of the correctly classified
observations (or the diagonal elements of the matrix) divided by the
total number of observations (or the sum of all observations).}
}
\value{
an nxn weighted confusion matrix
}
\description{
This function calculates the redistributed confusion matrix from a caret
ConfusionMatrix object or a simple matrix and optionally prints the
redistributed standard accuracy score. The redistributed confusion matrix
can serve to place significance on observations close to the diagonal by
applying a custom weighting scheme which transfers a proportion of the
non-diagonal observations to the diagonal.
}
\details{
The number of categories "n" should be greater or equal to 2.
}
\examples{
m = matrix(c(70,0,0,10,10,0,5,3,2), ncol = 3, nrow=3)
rconfusionmatrix(m, custom.weights = c(0,0.5,0.25),
                 print.weighted.accuracy = TRUE)

}
\seealso{
[weightmatrix()] for the weight matrix used in computations,
  [wconfusionmatrix()] for the computation of weighted confusion matrices,
  [balancedaccuracy()] for accuracy metrics designed for imbalanced data.
}
\author{
Alexandru Monahov, <https://www.alexandrumonahov.eu.org/>
}
\keyword{accuracy}
\keyword{confusion}
\keyword{matrix}
\keyword{redistributed}
\keyword{score}
