% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdpa_read.R
\name{wdpa_read}
\alias{wdpa_read}
\title{Read data}
\usage{
wdpa_read(x, n = NULL)
}
\arguments{
\item{x}{\code{character} file name for a zip archive file downloaded from
\url{https://www.protectedplanet.net/en}.}

\item{n}{\code{integer} number of records to import per data source.
Defaults to \code{NULL} such that all data are imported.}
}
\value{
A \code{\link[sf:sf]{sf::sf()}} object.
}
\description{
Read data obtained from
\href{https://www.protectedplanet.net/en}{Protected Planet}.
Specifically, this function is designed to import data obtained from
the World Database on Protected Areas
(WDPA) and the World Database on Other Effective Area-Based Conservation
Measures (WDOECM).
}
\details{
This function assumes that data have previously been downloaded to
your computer, and need to import the data.
After importing the data, it is strongly recommended to clean the data
prior to analysis (see \code{\link[=wdpa_clean]{wdpa_clean()}}).
}
\section{Data source}{

The \code{PA_DEF} column indicates the data source for individual
areas and sites that comprise the imported dataset.
Specifically, data obtained through the World Database on Protected Areas
(WDPA) are indicated with a value of \code{1} in the \code{PA_DEF} column.
Additionally, data obtained through the World Database on Other Effective
Area-Based Conservation Measures (WDOECM) are indicated with a value of \code{0}
in the \code{PA_DEF} column.
For more details on data conventions, please consult the official manual
(UNEP-WCMC 2019).
}

\examples{
\dontrun{
# find url for Liechtenstein dataset
download_url <- wdpa_url("LIE", wait = TRUE)

# path to save file zipfile with data
path <- tempfile(pattern = "WDPA_", fileext = ".zip")

# download zipfile
result <- httr::GET(download_url, httr::write_disk(path))

# load data
lie_raw_data <- wdpa_read(path)

# plot data
plot(lie_raw_data)
}
}
\references{
UNEP-WCMC (2019). User Manual for the World Database on Protected Areas and
world database on other effective area-based conservation measures: 1.6.
UNEP-WCMC: Cambridge, UK. Available at: \url{https://wcmc.io/WDPA_Manual}.
}
\seealso{
\code{\link[=wdpa_fetch]{wdpa_fetch()}}, \code{\link[=wdpa_clean]{wdpa_clean()}}.
}
