% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dew_point.R
\name{dp_mint}
\alias{dp_mint}
\title{Calculate Dew Point Temperature from Minimum Temperature and Relative Humidity}
\usage{
dp_mint(mint, minrh)
}
\arguments{
\item{mint}{Numeric. Minimum air temperature in degrees Celsius.}

\item{minrh}{Numeric. Relative humidity (\%) at minimum temperature.}
}
\value{
Numeric. Dew point temperature in degrees Celsius.
}
\description{
This function estimates the dew point temperature (C) using the Magnus-Tetens approximation,
based on the minimum air temperature and relative humidity at that time.
}
\details{
The dew point temperature is calculated using the following equations:

\deqn{
\gamma = \frac{a \cdot T}{b + T} + \ln\left(\frac{RH}{100}\right)
}
\deqn{
T_{dew} = \frac{b \cdot \gamma}{a - \gamma}
}

where \eqn{a = 17.62} and \eqn{b = 243.12}.
}
\examples{
dp_mint(10, 80)  # Expected output: around 6.71

}
