% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_e4_data_intervals.R
\name{filter_createdir_zip}
\alias{filter_createdir_zip}
\title{Function to filter the data object based on the time period and intervals that
are needed for the files to be cut.
The function also creates identical Empatica E4 zipfiles in the same directory as
where the original zipfile is located.}
\usage{
filter_createdir_zip(
  data,
  time_start,
  time_end,
  interval,
  out_path = NULL,
  fn_name = NULL
)
}
\arguments{
\item{data}{Object read with \code{\link{read_e4}}}

\item{time_start}{User input start time in the character format 
"yyyy-mm-dd hh:mm:ss" / e.g., "2019-11-27 08:32:00". Where do you want the file cut to start?}

\item{time_end}{User input end time (same format as time_start)}

\item{interval}{# Interval: User input interval (in minutes/ e.g., 5)
What is the duration of the interval you want to divide the period into? 
For example, the paper by de Looff et al. (2019) uses 5 minute intervals over
a 30 minute period preceding aggressive behavior. The 5 minute interval is 
chosen as for the calculation of some of the heart rate variability parameters 
one needs at least 5 minutes of data.}

\item{out_path}{The directory where to write the cut files; defaults to the input folder.}

\item{fn_name}{The directory where to write the cut files without the extension.}
}
\value{
out_path fn_name
}
\description{
Function to filter the data object based on the time period and intervals that
are needed for the files to be cut.
The function also creates identical Empatica E4 zipfiles in the same directory as
where the original zipfile is located.
}
