% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainmeasure_conversion.R
\name{inches_to_metric}
\alias{inches_to_metric}
\title{Convert from inches to standard metric units of measure for precipitation}
\usage{
inches_to_metric(inches, unit, round = 2)
}
\arguments{
\item{inches}{Numeric vector of precipitation (in inches)}

\item{unit}{Character specifying the metric precipitation unit besides inches.
Possible values are:
  \itemize{
    \item \code{mm}: Millimeters
    \item \code{cm}: Centimeters
  }}

\item{round}{An integer indicating the number of decimal places to
round the converted value.}
}
\value{
A numeric vector of precipitation (in specified metric unit)
}
\description{
\code{inches_to_metric} creates a numeric vector of precipitation in
  common metric units (millimeters or centimeters) from a numeric vector of
  precipitation in inches.
}
\note{
Equations are from the source code for the National Weather Service
   Forecast Office \url{http://www.srh.noaa.gov/ama/?n=conversions}
}
\examples{
data(breck)
breck$Precip.mm <- inches_to_metric(breck$Precip.in,
                                    unit = "mm",
                                    round = 2)
breck

}
\author{
Joshua Ferreri \email{joshua.m.ferreri@gmail.com},
Brooke Anderson \email{brooke.anderson@colostate.edu}
}
\references{
\url{http://www.srh.noaa.gov/ama/?n=conversions}
}
\seealso{
\code{\link{metric_to_inches}}
}

