% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element.R
\name{Element}
\alias{Element}
\title{HTML element}
\description{
HTML element
}
\section{Usage}{

\preformatted{e <- s$findElement(css = NULL, linkText = NULL,
    partialLinkText = NULL, xpath = NULL)

e$findElement(css = NULL, linkText = NULL,
    partialLinkText = NULL, xpath = NULL)
e$findElements(css = NULL, linkText = NULL,
    partialLinkText = NULL, xpath = NULL)

e$isSelected()
e$getValue()
e$setValue(value)
e$getAttribute(name)
e$getClass()
e$getCssValue(name)
e$getText()
e$getName()
e$getData(name)
e$getRect()
e$isEnabled()
e$click()
e$clear()
e$sendKeys(...)
e$moveMouseTo(xoffset = NULL, yoffset = NULL)

e$executeScript(script, ...)
e$executeScriptAsync(script, ...)
}
}

\section{Arguments}{

\describe{
  \item{e}{An \code{Element} object.}
  \item{s}{A \code{\link{Session}} object.}
  \item{css}{Css selector to find an HTML element.}
  \item{linkText}{Find \code{<a>} HTML elements based on their
    \code{innerText}.}
  \item{partialLinkText}{Find \code{<a>} HTML elements based on their
    \code{innerText}. It uses partial matching.}
  \item{xpath}{Find HTML elements using XPath expressions.}
  \item{name}{String scalar, named of attribute, property or css key.
    For \code{getData}, the key of the data attribute.}
  \item{xoffset}{Horizontal offset for mouse movement, relative to the
    position of the element. If at least of of \code{xoffset} and
    \code{yoffset} is \code{NULL}, then they are ignored.}
  \item{yoffset}{Vertical offset for mouse movement, relative to the
    position of the element. If at least of of \code{xoffset} and
    \code{yoffset} is \code{NULL}, then they are ignored.}
  \item{value}{Value to set, a character string.}
  \item{...}{For \code{sendKeys} the keys to send, see
    \code{\link{key}}. For \code{executeScript} and
    \code{executeScriptAsync} argument to supply to the script.}
}
}

\section{Details}{


To create \code{Element} objects, you need to use the \code{findElement}
(or \code{findElement}) method of a \code{\link{Session}} object.

\code{e$findElement()} finds the \emph{next} HTML element from the
current one. You need to specify one of the \code{css}, \code{linkText},
\code{partialLinkText} and \code{xpath} arguments. It returns a new
\code{Element} object.

\code{e$findElements()} finds all matching HTML elements starting from
the current element. You need to specify one of the \code{css},
\code{linkText}, \code{partialLinkText} and \code{xpath} arguments.
It returns a list of newly created \code{Element} objects.

\code{e$isSelected()} returns \code{TRUE} is the element is currently
selected, and \code{FALSE} otherwise.

\code{e$getValue()} returns the value of an input element, it is a
shorthand for \code{e$getAttribute("value")}.

\code{e$setValue()} sets the value of an input element, it is
essentially equivalent to sending keys via \code{e$sendKeys()}.

\code{e$getAttribute()} queries an arbitrary HTML attribute. It is
does not exist, \code{NULL} is returned.

\code{e$getClass()} uses \code{e$getAttribute} to parse the
\sQuote{class} attribute into a character vector.

\code{e$getCssValue()} queries a CSS property of an element.

\code{e$getText()} returns the \code{innerText} on an element.

\code{e$getName()} returns the tag name of an element.

\code{e$getData()} is a shorthand for querying \code{data-*} attributes.

\code{e$getRect()} returns the \sQuote{rectangle} of an element. It is
named list with components \code{x}, \code{y}, \code{height} and
\code{width}.

\code{e$isEnabled()} returns \code{TRUE} if the element is enabled,
\code{FALSE} otherwise.

\code{e$click()} scrolls the element into view, and clicks the
in-view centre point of it.

\code{e$clear()} scrolls the element into view, and then attempts to
clear its value, checkedness or text content.

\code{e$sendKeys()} scrolls the form control element into view, and
sends the provided keys to it. See \code{\link{key}} for a list of
special keys that can be sent.

\code{e$uploadFile()} uploads a file to a \code{<input type="file">}
element. The \code{filename} argument can contain a single filename,
or multiple filenames, for file inputs that can take multiple files.

\code{e$moveMouseTo()} moves the mouse cursor to the element, with
the specified offsets. If one or both offsets are \code{NULL}, then
it places the cursor on the center of the element. If the element is
not on the screen, then is scrolls it into the screen first.

\code{e$executeScript()} and \code{e$executeScriptAsync()}
call the method of the same name on the \code{\link{Session}} object.
The first argument of the script (\code{arguments[0]}) will always
hold the element object itself.
}

