% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_team.R
\name{wnba_teamdetails}
\alias{wnba_teamdetails}
\title{\strong{Get WNBA Stats API Team Details}}
\usage{
wnba_teamdetails(team_id = "1611661328", ...)
}
\arguments{
\item{team_id}{Team ID}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: TeamAwardsChampionships,
TeamAwardsConf, TeamAwardsDiv, TeamBackground,
TeamHistory, TeamHof, TeamRetired, TeamSocialSites

\strong{TeamBackground}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   ABBREVIATION \tab character \cr
   NICKNAME \tab character \cr
   YEARFOUNDED \tab character \cr
   CITY \tab character \cr
   ARENA \tab character \cr
   ARENACAPACITY \tab character \cr
   OWNER \tab character \cr
   GENERALMANAGER \tab character \cr
   HEADCOACH \tab character \cr
   DLEAGUEAFFILIATION \tab character \cr
}


\strong{TeamHistory}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   CITY \tab character \cr
   NICKNAME \tab character \cr
   YEARFOUNDED \tab character \cr
   YEARACTIVETILL \tab character \cr
}


\strong{TeamSocialSites}\tabular{ll}{
   col_name \tab types \cr
   ACCOUNTTYPE \tab character \cr
   WEBSITE_LINK \tab character \cr
}


\strong{TeamAwardsChampionships}\tabular{ll}{
   col_name \tab types \cr
   YEARAWARDED \tab character \cr
   OPPOSITETEAM \tab character \cr
}


\strong{TeamAwardsConf}\tabular{ll}{
   col_name \tab types \cr
   YEARAWARDED \tab integer \cr
   OPPOSITETEAM \tab integer \cr
}


\strong{TeamAwardsDiv}\tabular{ll}{
   col_name \tab types \cr
   YEARAWARDED \tab integer \cr
   OPPOSITETEAM \tab integer \cr
}


\strong{TeamHof}\tabular{ll}{
   col_name \tab types \cr
   PLAYERID \tab character \cr
   PLAYER \tab character \cr
   POSITION \tab character \cr
   JERSEY \tab character \cr
   SEASONSWITHTEAM \tab character \cr
   YEAR \tab character \cr
}


\strong{TeamRetired}\tabular{ll}{
   col_name \tab types \cr
   PLAYERID \tab character \cr
   PLAYER \tab character \cr
   POSITION \tab character \cr
   JERSEY \tab character \cr
   SEASONSWITHTEAM \tab character \cr
   YEAR \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Team Details}

\strong{Get WNBA Stats API Team Details}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_teamdetails(team_id = '1611661328')
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Team Functions: 
\code{\link{wnba_leaguedashteamstats}()},
\code{\link{wnba_teamdashboardbyclutch}()},
\code{\link{wnba_teamdashboardbygamesplits}()},
\code{\link{wnba_teamdashboardbygeneralsplits}()},
\code{\link{wnba_teamdashboardbylastngames}()},
\code{\link{wnba_teamdashboardbyopponent}()},
\code{\link{wnba_teamdashboardbyshootingsplits}()},
\code{\link{wnba_teamdashboardbyteamperformance}()},
\code{\link{wnba_teamdashboardbyyearoveryear}()},
\code{\link{wnba_teamdashlineups}()},
\code{\link{wnba_teamestimatedmetrics}()},
\code{\link{wnba_teamgamelogs}()},
\code{\link{wnba_teamgamelog}()},
\code{\link{wnba_teamgamestreakfinder}()},
\code{\link{wnba_teamhistoricalleaders}()},
\code{\link{wnba_teamplayerdashboard}()},
\code{\link{wnba_teamplayeronoffdetails}()},
\code{\link{wnba_teamplayeronoffsummary}()},
\code{\link{wnba_teams}()},
\code{\link{wnba_teamvsplayer}()},
\code{\link{wnba_teamyearbyyearstats}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Team Functions}
