% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcs_data.R
\name{mcs_delay_data}
\alias{mcs_delay_data}
\title{MCS Delay Data}
\usage{
mcs_delay_data(
  data = NULL,
  date_1,
  date_2,
  time,
  status = NULL,
  id = NULL,
  .keep_all = FALSE
)
}
\arguments{
\item{data}{Either \code{NULL} or a \code{data.frame}. If data is \code{NULL}, \code{date_1}, \code{date_2},
\code{time}, \code{status} and \code{id} must be vectors containing the data. Otherwise \code{date_1},
\code{date_2}, \code{time}, \code{status} and \code{id} can be either column names or column positions.}

\item{date_1}{A date of class \code{character} or \code{Date} in the format "yyyy-mm-dd",
representing the earlier of the two dates belonging to a particular delay.
Use \code{NA} for missing elements.

If more than one delay is to be considered, use a list for the vector-based
approach and a vector of column names or positions for the data-based approach.
The first element is the earlier date of the first delay, the second element is the
earlier date of the second delay, and so forth (see 'Examples').}

\item{date_2}{A date of class \code{character} or \code{Date} in the format "yyyy-mm-dd".
\code{date_2} is the counterpart of \code{date_1} and is used the same as \code{date_1}, just with
the later date(s) of the particular delay(s). Use \code{NA} for missing elements.}

\item{time}{Operating times. Use \code{NA} for missing elements.}

\item{status}{Optional argument. If used, it must contain binary data
(0 or 1) indicating whether a unit is a right censored observation (= 0) or a
failure (= 1).

If \code{status} is provided, class \code{wt_reliability_data} is assigned to the
output of \link{mcs_delay}, which enables the direct application of \link{estimate_cdf}
on operating times.}

\item{id}{Identification of every unit.}

\item{.keep_all}{If \code{TRUE} keep remaining variables in \code{data}.}
}
\value{
A \code{tibble} with class \code{wt_mcs_delay_data} that is formed for the downstream
Monte Carlo method \link{mcs_delay}.
It contains the following columns (if \code{.keep_all = FALSE}):
\itemize{
\item Column(s) preserving the input of \code{date_1}. For the vector-based approach
with unnamed input, column name(s) is (are) \code{date_1}
(\code{date_1.1}, \code{date_1.2}, \code{...}, \code{date_1.i}).
\item Column(s) preserving the input of \code{date_2}. For the vector-based approach
with unnamed input, column name(s) is (are) \code{date_2}
(\code{date_2.1}, \code{date_2.2}, \code{...}, \code{date_2.i}).
\item \code{time} : Input operating times.
\item \code{status} (\strong{optional}) :
\itemize{
\item If \code{is.null(status)} column \code{status} does not exist.
\item If \code{status} is provided the column contains the entered binary
data (0 or 1).
}
\item \code{id} : Identification for every unit.
}

If \code{.keep_all = TRUE}, the remaining columns of \code{data} are also preserved.

The attributes \code{mcs_start_dates} and \code{mcs_end_dates} hold the name(s) of the
column(s) that preserve the input of \code{date_1} and \code{date_2}.
}
\description{
Create consistent \code{mcs_delay_data} based on an existing \code{data.frame} (preferred)
or on multiple equal length vectors.
}
\examples{
# Example 1 -  Based on an existing data.frame/tibble and column names:
mcs_tbl <- mcs_delay_data(
  data = field_data,
  date_1 = production_date,
  date_2 = registration_date,
  time = dis,
  status = status
)

# Example 2 - Based on an existing data.frame/tibble and column positions:
mcs_tbl_2 <- mcs_delay_data(
  data = field_data,
  date_1 = 7,
  date_2 = 8,
  time = 2,
  id = 1
)

# Example 3 - Keep all variables of the tibble/data.frame entered to argument data:
mcs_tbl_3 <- mcs_delay_data(
  data = field_data,
  date_1 = production_date,
  date_2 = registration_date,
  time = dis,
  status = status,
  id = vin,
  .keep_all = TRUE
)

# Example 4 - For multiple delays (data-based):
mcs_tbl_4 <- mcs_delay_data(
  data = field_data,
  date_1 = c(production_date, repair_date),
  date_2 = c(registration_date, report_date),
  time = dis,
  status = status
)

# Example 5 - Based on vectors:
mcs_tbl_5 <- mcs_delay_data(
  date_1 = field_data$production_date,
  date_2 = field_data$registration_date,
  time = field_data$dis,
  status = field_data$status,
  id = field_data$vin
)

# Example 6 - For multiple delays (vector-based):
mcs_tbl_6 <- mcs_delay_data(
  date_1 = list(field_data$production_date, field_data$repair_date),
  date_2 = list(field_data$registration_date, field_data$report_date),
  time = field_data$dis,
  status = field_data$status,
  id = field_data$vin
)

# Example 7 - For multiple delays (vector-based with named dates):
mcs_tbl_7 <- mcs_delay_data(
  date_1 = list(d11 = field_data$production_date, d12 = field_data$repair_date),
  date_2 = list(d21 = field_data$registration_date, d22 = field_data$report_date),
  time = field_data$dis,
  status = field_data$status,
  id = field_data$vin
)

}
\seealso{
\link{dist_delay} for the determination of a parametric delay distribution
and \link{mcs_delay} for the Monte Carlo method with respect to delays.
}
