% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict_prob}
\alias{predict_prob}
\title{Prediction of Failure Probabilities for Parametric Lifetime Distributions}
\usage{
predict_prob(
  q,
  dist_params,
  distribution = c("weibull", "lognormal", "loglogistic", "sev", "normal", "logistic",
    "weibull3", "lognormal3", "loglogistic3", "exponential", "exponential2")
)
}
\arguments{
\item{q}{A numeric vector of quantiles.}

\item{dist_params}{A vector of parameters. An overview of the
distribution-specific parameters can be found in section 'Distributions'.}

\item{distribution}{Supposed distribution of the random variable.}
}
\value{
A vector with predicted (failure) probabilities.
}
\description{
This function predicts the (failure) probabilities of a parametric lifetime
distribution using the (log-)location-scale parameterization.
}
\details{
For a given set of parameters and specified quantiles the probabilities
of the chosen model are determined.
}
\section{Distributions}{

The following table summarizes the available distributions and their parameters
\itemize{
\item \emph{location parameter} \eqn{\mu},
\item \emph{scale parameter} \eqn{\sigma} or \eqn{\theta} and
\item \emph{threshold parameter} \eqn{\gamma}.
}

The order within \code{dist_params} is given in the table header.\tabular{lccc}{
   \strong{\code{distribution}} \tab \strong{\code{dist_params[1]}} \tab \strong{\code{dist_params[2]}} \tab \strong{\code{dist_params[3]}} \cr
   \code{"sev"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab - \cr
   \code{"weibull"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab - \cr
   \code{"weibull3"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab \eqn{\gamma} \cr
   \code{"normal"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab - \cr
   \code{"lognormal"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab - \cr
   \code{"lognormal3"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab \eqn{\gamma} \cr
   \code{"logistic"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab - \cr
   \code{"loglogistic"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab - \cr
   \code{"loglogistic3"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab \eqn{\gamma} \cr
   \code{"exponential"} \tab \eqn{\theta} \tab - \tab - \cr
   \code{"exponential2"} \tab \eqn{\theta} \tab \eqn{\gamma} \tab - \cr
}
}

\examples{
# Example 1 - Predicted probabilities for a two-parameter weibull distribution:
probs_weib2 <- predict_prob(
  q = c(15, 48, 124),
  dist_params = c(5, 0.5),
  distribution = "weibull"
)

# Example 2 - Predicted quantiles for a three-parameter weibull distribution:
probs_weib3 <- predict_prob(
  q = c(25, 58, 134),
  dist_params = c(5, 0.5, 10),
  distribution = "weibull3"
)

}
