% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_word.R
\name{find_word}
\alias{find_word}
\alias{find_word_l}
\title{Find words that fit the chosen parameters.}
\usage{
find_word(model = "*", allow = letters, ban = character(0),
  type = "usual", words = wfindr::words.eng)

find_word_l(model = "*", allow = letters, ban = character(0),
  type = "usual", words = wfindr::words.eng)
}
\arguments{
\item{model}{pattern that a word should match. Consists of letters and
unknown characters specifications. Dot \code{.} stands for unknown
character. It may be followed by \code{\{...\}} repetition quantifier (i.e.
\code{.\{n\}}, \code{.\{n,\}}, \code{.\{n,m\}}). Asterisk \code{*} stands
for unknown number of unknown characters. See examples.\cr By default
\code{model} is set to \code{"*"}.}

\item{allow}{characters allowed to fill gaps in a word. Can be listed in a
single string or in a vector. By default is set to \code{letters}.}

\item{ban}{characters not allowed to fill gaps in a word.}

\item{type}{can be \code{"usual"}, \code{"scrabble"}, or \code{"anagram"}.
Abbreviated input is allowed: e.g. \code{"u"}, \code{"s"}, or
\code{"a"}.\cr \code{type} defines how often allowed characters can be used
to fill the gaps. Say, character appears \code{n} times in \code{allow} and
\code{m} times in \code{ban}. If \code{d = n - m} is less or equal to zero,
whatever the \code{type} is, this character won't be used to fill the gaps.
For the case when \code{d > 0}:\cr \itemize{ \item If \code{type} is
\code{"usual"} then the character is allowed to fill the gaps
\strong{unlimited} number of times. \cr \item If \code{type} is
\code{"scrabble"} then the character is allowed to fill the gaps \strong{no
more} than d times. \item If \code{type} is \code{"anagram"} then the
character should be used \strong{exactly} d times. }}

\item{words}{vector of words to search within. By default is set to
\code{\link{words.eng}}.}
}
\description{
Uses regex constructed by \code{\link{model_to_regex}} to search
  words. By default the search is done among \code{\link{words.eng}}.\cr
  \code{find_word} returns a vector of found words, \code{find_word_l}
  returns a logical vector that can be used for subsetting.
}
\examples{
## Search 4-letter words starting with "c".
find_word("c.{3}")
## Disallow "a" and "b".
find_word("c.{3}", ban = "ab")
## Allow only "a" and "b" to fill the gap.
find_word("c.{3}", allow = "ab")
## Allow "a", "b", and "c", but then ban "c"
## result is the same as in the previous example
find_word("c.{3}", allow = "abc", ban = "c")

## Find no more than 4-letter words that have "th" bigram
library(magrittr)
find_word(".{0,4}") \%>\% find_word("*th*", words = .)
## count words that start with "th"
sum(find_word_l("th*"))
length(find_word("th*"))

## Find words that can be constructed of the "thing" word's letters.
find_word(allow = "thing", type = "scrabble")
## Get at lest 4-letter words.
find_word(".{4,}", allow = "thing", type = "scrabble")

## Find anagrams of the word "thing"
find_word(allow = "thing", type = "anagram")
}
\seealso{
\code{\link{scrabble}}, \code{\link{anagram}}
}

