% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-page-data.R
\name{page_vector_functions}
\alias{page_vector_functions}
\alias{get_latest_revision}
\alias{get_page_html}
\alias{get_page_summary}
\alias{get_page_talk}
\alias{get_page_langlinks}
\title{Get data about pages from their titles}
\usage{
get_latest_revision(title, language = "en", failure_mode = "error")

get_page_html(title, language = "en", failure_mode = "error")

get_page_summary(title, language = "en", failure_mode = "error")

get_page_talk(title, language = "en", failure_mode = "error")

get_page_langlinks(title, language = "en", failure_mode = "error")
}
\arguments{
\item{title}{A character vector of page titles.}

\item{language}{A character vector of two-letter language codes, either of
length 1 or the same length as \code{title}}

\item{failure_mode}{Either "quiet" or "error." See \code{\link[=get_rest_resource]{get_rest_resource()}}}
}
\value{
A list, vector or tibble, the same length as \code{title}, with the
desired data.
}
\description{
\code{get_latest_revision()} returns metadata about the latest
revision of each
page.

\code{get_page_html()} returns the rendered html for each
page.

\code{get_page_summary()} returns metadata about the latest revision, along
with the page description and a summary extracted from the opening
paragraph

\code{get_page_related()} returns summaries for 20 related pages for each
passed page

\code{get_page_talk()} returns structured talk page content for each
title. You must ensure to use the title for the Talk page itself, e.g.
"Talk:Earth" rather than "Earth"

\code{get_page_langlinks()} returns interwiki links for each
title
}
\examples{
# Get language links for a known page on English Wikipedia
get_page_langlinks("Charles Harpur", failure_mode = "quiet")

# The functions are vectorised over title and language
# Find all articles about Joanna Baillie, and retrieve summary data for
# the first two.
baillie <- get_page_langlinks("Joanna Baillie") \%>\%
  dplyr::slice(1:2) \%>\%
  dplyr::mutate(get_page_summary(title = title, language = code, failure_mode = "quiet"))
baillie
}
