% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/W_stat.R
\name{W_stat}
\alias{W_stat}
\title{Wilcoxon Sign Rank Test Statistic Exact Distribution}
\usage{
W_stat(n , test_stat, side = c('geq','leq','eq'))
}
\arguments{
\item{n}{Size of data or Number of observations}

\item{test_stat}{The x value specified in  P(W=x), P(W<=x), P(W>=x)}

\item{side}{The tails of exact probability the user wants to compute  e.g.
'eq' = P(W=x), 'leq' = P(W<=x), 'geq' = 'P(W>=x)}
}
\value{
The exact probability values as specified.
}
\description{
This function allows the user to find the probability
values from the exact distribution of W, Bickel and Doksum(1973).
The exact P(W=x), P(W<=x), P(W>=x) values is found via an exhaustive enumeration
of the possible permutations of data with size n.
}
\examples{
W_stat(n=5, test_stat = 3, side = 'leq')
}
