% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.windows.R
\name{segment.windows}
\alias{segment.windows}
\title{Displays how  spectra are divided in windows}
\usage{
segment.windows(
  xblock = NULL,
  yblock = NULL,
  windows = 3,
  fade = 0.3,
  xlab = "Wavelength",
  ylab = "Absorbance",
  title = paste("Spectra divided in", windows, "segments", sep = " "),
  legend = NULL,
  grad = 10
)
}
\arguments{
\item{xblock}{A matrix containing one spectra for each observation.}

\item{yblock}{A vector containing the concentration associated to each spectra in the \emph{xblock} matrix.}

\item{windows}{Number of windows the spectra has to be divided in.}

\item{fade}{Opacity of the window.}

\item{xlab}{Title of the x axis.}

\item{ylab}{Title of the y axis.}

\item{title}{Title of the plot.}

\item{legend}{Name of the substance which drives the gradient of spectra’s mapping.}

\item{grad}{Number of colors that are used to build the gradient.}
}
\value{
Plot of spectra in which segments have a different background color.
}
\description{
Displays how  spectra are divided in windows
}
\examples{
data(beer)
conc=unlist(beer[,1])
sp=beer[,2:ncol(beer)]
names(sp)=convert.names.wl(1100,2250,2)
segment.windows(sp,conc,windows=7,fade=0.25)
}
