% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_functions.R
\name{isometric_timing}
\alias{isometric_timing}
\title{Compute timing and magnitude of force in isometric trials}
\usage{
isometric_timing(x, rising = c(10, 90), relaxing = c(90, 50))
}
\arguments{
\item{x}{A \code{muscle_stim} object that contains data from an isometric
twitch trial, ideally created via \code{read_ddf}.}

\item{rising}{Set points of the rising phase to be described.
By default: 10\% and 90\%.}

\item{relaxing}{Set points of the relaxation phase to be described.
By default: 90\% and 50\%.}
}
\value{
A \code{data.frame} with the following metrics as columns:
\item{file_ID }{File ID}
\item{time_stim}{Time between beginning of data collection and when
stimulation occurs}
\item{force_stim}{Magnitude of force at the onset of stimulation}
\item{time_peak}{Absolute time of peak force, i.e. time between beginning of
data collection and when peak force occurs}
\item{force_peak}{Magnitude of peak force}
\item{time_rising_X}{Time between beginning of data collection and X\% of
 force development}
\item{force_rising_X}{Magnitude of force at X\% of force development}
\item{time_relaxing_X}{Time between beginning of data collection and X\% of
 force relaxation}
\item{force_relaxing_X}{Magnitude of force at X\% of relaxation}
}
\description{
Calculate timing and magnitude of force at stimulation, peak force, and
various parts of the rising (force development) and relaxation (falling)
phases of the twitch.
}
\details{
The \code{data.frame} (x) must have time series data organized in
columns. Generally, it is preferred that you use a \code{muscle_stim} object
imported by \code{read_ddf()}.

The \code{rising} and \code{relaxing} arguments allow for the user to supply
numeric vectors of any length. By default, these arguments are
\code{rising = c(10, 90)} and \code{relaxing  = c(90, 50)}. Numbers in each
of these correspond to percent values and capture time and force at that
percent of the corresponding curve. These values can be replaced by those
that the user specifies and do not necessarily need to have length = 2. But
please note that 0 and 100 should not be used, e.g.
\code{rising = seq(10, 90, 5)} works, but \code{rising = seq(0, 100, 5)}
does not.
}
\examples{

library(workloopR)

# import the twitch.ddf file included in workloopR
twitch_dat <-read_ddf(system.file("extdata", "twitch.ddf",
                                  package = 'workloopR'))

# run isometric_timing() to get info on twitch kinetics
# we'll use different set points than the defaults
analyze_twitch <- isometric_timing(twitch_dat,
  rising = c(25, 50, 75),
  relaxing = c(75, 50, 25)
)

# see the results
analyze_twitch

}
\references{
Ahn AN, and Full RJ. 2002. A motor and a brake: two leg extensor
muscles acting at the same joint manage energy differently in a running
insect. Journal of Experimental Biology 205, 379-389.
}
\seealso{
Other data analyses: 
\code{\link{analyze_workloop}()},
\code{\link{read_analyze_wl_dir}()},
\code{\link{read_analyze_wl}()}

Other twitch functions: 
\code{\link{fix_GR}()},
\code{\link{invert_position}()}
}
\author{
Vikram B. Baliga
}
\concept{data analyses}
\concept{twitch functions}
