% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_fotmob.R
\name{load_fotmob_matches_by_date}
\alias{load_fotmob_matches_by_date}
\title{Load pre saved fotmob match ids by date}
\usage{
load_fotmob_matches_by_date(country, league_name, league_id, cached = TRUE)
}
\arguments{
\item{country}{Three character country code. Can be one or multiple. If provided, `league_name` must also be provided (of the same length)}

\item{league_name}{League names. If provided, `country` must also be provided (of the same length).}

\item{league_id}{Fotmob ID for the league. Only used if `country` and `league_name` are not specified.}

\item{cached}{Whether to load the dataframe from the \href{https://github.com/JaseZiv/worldfootballR_data/blob/master/raw-data/fotmob-leagues/all_leagues.csv}{data CSV}. This is faster and most likely what you want to do, unless you identify a league that's being tracked by fotmob that's not in this pre-saved CSV.}
}
\value{
returns a dataframe of league match ids
}
\description{
Loading version of \code{fotmob_get_matches_by_date}. Goes back to August 2017.
}
\examples{
\dontrun{
try({
## just load match ids
load_fotmob_matches_by_date(
  country = "ENG",
  league_name = "Premier League"
)

## can also do it for multiple leagues
load_fotmob_matches_by_date(
  country =     c("ENG",            "ESP"   ),
  league_name = c("Premier League", "LaLiga")
)
})
}
}
