% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hf.R
\name{hf}
\alias{hf}
\title{Patameter Estimation for W-test Probability Distribution}
\usage{
hf(data, w.order, B = 400, n.sample = nrow(data),
  n.marker = "default.nmarker")
}
\arguments{
\item{data}{a data frame or matrix containing genotypes in the columns and subjects in the rows. Genotypes should be coded as (0, 1, 2) or (0, 1).}

\item{w.order}{a numeric number. \code{w.order} = 1 gives main effect calculation. \code{w.order} = 2 gives pairwise interaction calculation. \code{w.order} > 2 gives high order interaction calculation.}

\item{B}{a numeric number specifying the number of replicates. Default is 400.}

\item{n.sample}{a numeric number specifying the number of samples to be used for estimating parameters. Default is the total number of samples in the data.}

\item{n.marker}{a numeric value, the number of biomarkers to include in bootstrapping. For \code{order} = 1, the default = min(P, 1000), and for order = 2, default = min(P, 50). P is the total number of markers in the data.}
}
\value{
a set of \emph{h} and \emph{f} values indexed by \emph{k}, estimated automatically. For main effect, \emph{k} is the number of levels of a predictor variable. For interactions, \emph{k} is the number of categorical combinations of a variable pair.
}
\description{
Estimate parameters (\emph{h} and \emph{f}) for \code{W-test}.
}
\examples{
data(diabetes.geno)

# Please note that parameter B is recommended to be greater than 400.
# For high order interaction analysis (w.order > 2), it is recommended to use default n.sample.
hf1 <- hf(data = diabetes.geno, w.order = 1, B = 100)
hf2 <- hf(data = diabetes.geno, w.order = 2, B = 80)
}
\references{
Maggie Haitian Wang, Rui Sun, Junfeng Guo, Haoyi Weng, Jack Lee, Inchi Hu, Pak Sham and Benny C.Y. Zee (2016). A fast and powerful W-test for pairwise epistasis testing. Nucleic Acids Research. doi:10.1093/nar/gkw347.
}
\seealso{
\code{\link{wtest}}, \code{\link{w.diagnosis}}, \code{\link{w.qqplot}}
}
\author{
Rui Sun, Maggie Haitian Wang
}
