% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNF.R
\name{id2symb}
\alias{id2symb}
\title{Convert a numeric identifier to a symbol.}
\usage{
id2symb(Id, ST)
}
\arguments{
\item{Id}{A numeric identifier (integer).}

\item{ST}{A symbol table.}
}
\value{
\itemize{
        \item  A symbol string if the identifier exists or 
        \item  an empty character string (\code{character(0)}) 
               if the identifier 
               does not exist.}
}
\description{
\code{id2symb()} converts a numeric id to a symbol.
}
\examples{
g<-compileBNF(booleanGrammar())
id2symb(1, g$ST)
id2symb(2, g$ST)
id2symb(5, g$ST)
id2symb(12, g$ST)
id2symb(15, g$ST)
identical(id2symb(15, g$ST), character(0))

}
\seealso{
Other Utility Functions: 
\code{\link{derive}()},
\code{\link{isNonTerminal}()},
\code{\link{isTerminal}()},
\code{\link{rules}()},
\code{\link{symb2id}()}
}
\concept{Utility Functions}
