% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geTree.R
\name{rndsubk}
\alias{rndsubk}
\title{Transforms a non-terminal symbol into a 1-level derivation tree 
for a given k.}
\usage{
rndsubk(sym, k, PT)
}
\arguments{
\item{sym}{Non-terminal symbol.}

\item{k}{Codon (An integer).}

\item{PT}{Production table.}
}
\value{
1-level derivation tree.
}
\description{
\code{rndsubk()} expands a non-terminal by a derivation
             specified by k and returns a 1-level derivation tree.
}
\examples{
g<-compileBNF(booleanGrammar())
rndsubk(g$Start, 207, g$PT)

}
\seealso{
Other Generate Derivation Tree: 
\code{\link{generateCDT}()},
\code{\link{generateDerivationTree}()},
\code{\link{randomDerivationTree}()},
\code{\link{rndsub}()},
\code{\link{substituteSymbol}()}
}
\concept{Generate Derivation Tree}
