% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_frag.R
\name{add_child_fragment}
\alias{add_child_fragment}
\title{Add a child fragment to an existing xml_fragment}
\usage{
add_child_fragment(x, ..., .frag = frag(...))
}
\arguments{
\item{x}{an \code{\link[=xml_fragment]{xml_fragment()}} object}

\item{...}{nest named elements and characters to include in the fragment (see example)}

\item{.frag}{an xml_fragment to add as a child, overrides the ... argument}
}
\value{
the original \code{\link[=xml_fragment]{xml_fragment()}} with the child added.
}
\description{
Add a child fragment to an existing xml_fragment.
The child fragment can be a named \code{frag} element in which case the name
is used as the tag name, an unnamed element in which case the element
is added as a text node. This functionality is equivalent with the \code{/} operator.
}
\seealso{
Other xml_fragment: 
\code{\link{as.character.xml_fragment}()},
\code{\link{as_frag}()},
\code{\link{as_xml_nodeset}()},
\code{\link{data_frag}()},
\code{\link{frag}()},
\code{\link{xml_fragment}()}
}
\concept{xml_fragment}
