% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters_tskrr.R
\name{response,tskrr-method}
\alias{response,tskrr-method}
\alias{response}
\alias{lambda,tskrrHomogeneous-method}
\alias{lambda,tskrrHeterogeneous-method}
\alias{lambda}
\alias{is_tskrr}
\alias{is_homogeneous}
\alias{is_heterogeneous}
\alias{symmetry}
\alias{get_eigen}
\alias{get_kernelmatrix}
\alias{has_hat}
\alias{get_kernel}
\title{Getters for tskrr objects}
\usage{
\S4method{response}{tskrr}(x, ...)

\S4method{lambda}{tskrrHomogeneous}(x)

\S4method{lambda}{tskrrHeterogeneous}(x)

is_tskrr(x)

is_homogeneous(x)

is_heterogeneous(x)

symmetry(x)

get_eigen(x, which = c("row", "column"))

get_kernelmatrix(x, which = c("row", "column"))

has_hat(x)

get_kernel(x, which = c("row", "column"))
}
\arguments{
\item{x}{a \code{\link[xnet:tskrr-class]{tskrr}} object or an
object inheriting from \code{tskrr}.}

\item{...}{arguments passed to other methods.}

\item{which}{a character value indicating whether the eigen decomposition
for the row kernel matrix or the column kernel matrix should be returned.}
}
\value{
For \code{response}: the original label matrix

For \code{lambda}: a named numeric vector with one resp both lambda
values used in the model. The names are "k" and "g" respectively.

For \code{is_tskrr} a logical value indicating whether the
object is a \code{tskrr} object

For \code{is_homogeneous} a logical value indicating whether the
tskrr model is a homogeneous one.

For \code{is_heterogeneous} a logical value indicating whether the
tskrr model is a heterogeneous one.

For \code{symmetry} a character value indicating the symmetry
for a \code{\link[xnet:tskrrHomogeneous-class]{homogeneous model}}. If
the model is not homogeneous, \code{NA} is returned.

For \code{get_eigen} the eigen decomposition of the requested
kernel matrix.

For \code{get_kernelmatrix} the original kernel matrix
for the rows or columns.

For \code{has_hat} a logical value indicating whether
the tskrr model contains the kernel hat matrices.
}
\description{
The functions described here are convenience functions to get
information out of a \code{\link[xnet:tskrr-class]{tskrr}} object.
}
\section{Warning}{
 The function \code{get_kernel} is deprecated.
Use \code{get_kernelmatrix} instead.
}

\examples{
data(drugtarget)

mod <- tskrr(drugTargetInteraction, targetSim, drugSim)
is_homogeneous(mod)

EigR <- get_eigen(mod)
EigC <- get_eigen(mod, which = 'column')
lambda(mod)

}
