% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/loo.R
\name{loo}
\alias{loo}
\alias{loo,tskrrHeterogeneous-method}
\alias{loo,tskrrHomogeneous-method}
\alias{loo,linearFilter-method}
\title{Leave-one-out cross-validation for tskrr}
\usage{
loo(x, ...)

\S4method{loo}{tskrrHeterogeneous}(
  x,
  exclusion = c("interaction", "row", "column", "both"),
  replaceby0 = FALSE
)

\S4method{loo}{tskrrHomogeneous}(
  x,
  exclusion = c("edges", "vertices", "interaction", "both"),
  replaceby0 = FALSE
)

\S4method{loo}{linearFilter}(x, replaceby0 = FALSE)
}
\arguments{
\item{x}{an object of class \code{\link[xnet:tskrr-class]{tskrr}} or
\code{\link{linearFilter}}.}

\item{...}{arguments passed to methods.
See Details.}

\item{exclusion}{a character value with possible values "interaction",
"row", "column", "both" for heterogeneous models, and "edges", "vertices",
"interaction" or "both" for homogeneous models.
Defaults to "interaction". See details.}

\item{replaceby0}{a logical value indicating whether the interaction
should be simply removed (\code{FALSE}) or replaced by 0 (\code{TRUE}).}
}
\value{
a numeric matrix with the leave-one-out predictions for
the model.
}
\description{
Perform a leave-one-out cross-validation for two-step kernel
ridge regression based on the shortcuts described in Stock et al, 2018.
(\url{http://doi.org/10.1093/bib/bby095}).
}
\details{
The parameter \code{exclusion} defines what is left out.
The value "interaction" means that a single interaction is removed.
In the case of a homogeneous model, this can be interpreted as the
removal of the interaction between two edges. The values "row" and
"column" mean that all interactions for a row edge resp. a column
edge are removed. The value "both" removes all interactions for
a row and a column edge.

In the case of a homogeneous model, "row" and "column" don't make sense
and will be replaced by "both" with a warning. This can be interpreted
as removing vertices, i.e. all interactions between one edge and
all other edges. Alternatively one can use "edges" to remove edges and
"vertices" to remove vertices. In the case of a homogeneous model,
the setting "edges" translates to "interaction", and "vertices"
translates to "both". For more information, see Stock et al. (2018).

Replacing by 0 only makes sense when \code{exclusion = "interaction"} and the
label matrix contains only 0 and 1 values. The function checks whether
the conditions are fulfilled and if not, returns an error.
}
\examples{
data(drugtarget)

mod <- tskrr(drugTargetInteraction, targetSim, drugSim,
             lambda = c(0.01,0.01))

delta <- loo(mod, exclusion = 'both') - response(mod)
delta0 <- loo(mod, replaceby0 = TRUE) - response(mod)

}
