% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.tskrr}
\alias{predict.tskrr}
\alias{predict,tskrr-method}
\title{predict method for tskrr fits}
\usage{
\method{predict}{tskrr}(object, k = NULL, g = NULL, testdim = TRUE, ...)

\S4method{predict}{tskrr}(object, k = NULL, g = NULL, testdim = TRUE, ...)
}
\arguments{
\item{object}{an object of class \code{\link[xnet:tskrr-class]{tskrr}}.}

\item{k}{a new K matrix or \code{NULL}. if \code{NULL}, the fitted
values on the training data are returned.}

\item{g}{a new G matrix or \code{NULL}. If \code{NULL}, K is used
for both.}

\item{testdim}{a logical value indicating whether the dimensions should
be checked prior to the calculation. You can set this to \code{FALSE} but
you might get more obscure errors if dimensions don't match.}

\item{...}{arguments passed to or from other methods}
}
\value{
a matrix with predicted values.
}
\description{
Obtains the predictions from a \code{\link{tskrr}} model for new data.
To get the predictions on the training data,
use the function \code{\link[xnet:fitted]{fitted}}
or set both \code{k} and \code{g} to \code{NULL}.
}
\details{
Predictions can be calculated between new vertices and the vertices
used to train the model, between new sets of vertices, or both. Which
predictions are given, depends on the kernel matrices passed to the
function.

In any case, both the K and G matrix need the kernel values for
every combination of the new vertices and the vertices used to
train the model. This is illustrated for both homogeneous and
heterogeneous networks in the examples.

To predict the links between a new set of vertices and the training
vertices, you need to provide the kernel matrix for either the K
or the G set of vertices. If you want to predict the mutual links
between two new sets of vertices, you have to provide both the
K and the G matrix. This is particularly important for homogeneous
networks: if you only supply the \code{k} argument, you will get
predictions for the links between the new vertices and the vertices
on which the model is trained. So in order to get the
mutual links between the new vertices, you need to provide the kernel
matrix as the value for both the \code{k} and the \code{g} argument.
}
\section{Warning}{

This function is changed in version 0.1.9 so it's more consistent
in how it expects the K and G matrices to be ordered. Up to version
0.1.8 the new vertices should be on the rows for the K matrix and on
the columns for the G matrix. This lead to confusion.

If you're using old code, you'll get an error pointing this out.
You need to transpose the G matrix in the old code to make it work
with the new version.
}

\examples{

## Predictions for homogeneous networks

data(proteinInteraction)

idnew <- sample(nrow(Kmat_y2h_sc), 20)

trainY <- proteinInteraction[-idnew,-idnew]
trainK <- Kmat_y2h_sc[-idnew,-idnew]

testK <- Kmat_y2h_sc[idnew, - idnew]

mod <- tskrr(trainY, trainK, lambda = 0.1)
# Predict interaction between test vertices
predict(mod, testK, testK)

# Predict interaction between test and train vertices
predict(mod, testK)
predict(mod, g = testK)

## Predictions for heterogeneous networks
data("drugtarget")

idnewK <- sample(nrow(targetSim), 10)
idnewG <- sample(ncol(drugSim), 10)

trainY <- drugTargetInteraction[-idnewK, -idnewG]
trainK <- targetSim[-idnewK, -idnewK]
trainG <- drugSim[-idnewG, -idnewG]

testK <- targetSim[idnewK, -idnewK]
testG <- drugSim[idnewG, -idnewG]

mod <- tskrr(trainY, trainK, trainG, lambda = 0.01)

# Predictions for new targets on drugs in model
predict(mod, testK)
# Predictions for new drugs on targets in model
predict(mod, g = testG)
# Predictions for new drugs and targets
predict(mod, testK, testG)

}
\seealso{
\code{\link{tskrr}} and \code{\link{tskrrTune}} for
fitting the models.
}
