% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{params}
\alias{params}
\title{Parameter Descriptions for ypr Functions}
\arguments{
\item{tmax}{The maximum age (yr).}

\item{k}{The VB growth coefficient (yr-1).}

\item{Linf}{The VB mean maximum length (cm).}

\item{t0}{The (theoretical) age at zero length (yr).}

\item{k2}{The VB growth coefficient after length L2 (yr-1).}

\item{Linf2}{The VB mean maximum length after length L2 (cm).}

\item{L2}{The length (or age if negative) at which growth switches from the
first to second phase (cm or yr).}

\item{Wb}{The weight (as a function of length) scaling exponent.}

\item{Ls}{The length (or age if negative) at which 50 \% mature (cm or yr).}

\item{Sp}{The maturity (as a function of length) power.}

\item{es}{The annual probability of a mature fish spawning.}

\item{Sm}{The spawning mortality probability.}

\item{fb}{The fecundity (as a function of weight) scaling exponent.}

\item{tR}{The age from which survival is density-independent (yr).}

\item{BH}{Recruitment follows a Beverton-Holt (1) or Ricker (0) relationship.}

\item{Rk}{The lifetime spawners per spawner at low density (or the egg to tR survival if between 0 and 1).}

\item{n}{The annual interval natural mortality rate from age tR.}

\item{nL}{The annual interval natural mortality rate from length Ln.}

\item{Ln}{The length  (or age if negative) at which the natural mortality
rate switches from n to nL (cm or yr).}

\item{Lv}{The length (or age if negative) at which 50 \% vulnerable to harvest
(cm or yr).}

\item{Vp}{The vulnerability to harvest (as a function of length) power.}

\item{Llo}{The lower harvest slot length (cm).}

\item{Lup}{The upper harvest slot length (cm).}

\item{Nc}{The slot limits non-compliance probability.}

\item{pi}{A vector of probabilities of capture to calculate the yield for.}

\item{rho}{The release probability.}

\item{Hm}{The hooking mortality probability.}

\item{Rmax}{The number of recruits at the carrying capacity (ind).}

\item{Wa}{The (extrapolated) weight of a 1 cm individual (g).}

\item{fa}{The (theoretical) fecundity of a 1 g female (eggs).}

\item{q}{The catchability (annual probability of capture) for a unit of
effort.}

\item{RPR}{The relative proportion of recruits that are of the ecotype.}

\item{all}{A flag specifying whether to include all parameter values.}

\item{u}{A flag specifying whether to plot the exploitation rate as opposed
to the capture rate.}

\item{percent}{A flag specifying whether to plot the number of fish as a
percent or frequency (the default).}

\item{color}{A string of the color around each bar (or NULL).}

\item{population}{An object of class \code{\link[=ypr_population]{ypr_population()}}.}

\item{populations}{An object of class \code{\link[=ypr_populations]{ypr_populations()}}.}

\item{ecotypes}{An object of class \code{\link[=ypr_ecotypes]{ypr_ecotypes()}}.}

\item{plot_values}{A flag specifying whether to plot the actual and optimal
values.}

\item{Ly}{The minimum length (trophy) fish to consider when calculating the
yield (cm).}

\item{harvest}{A flag specifying whether to calculate the yield for harvested
fish or captures.}

\item{biomass}{A flag specifying whether to calculate the yield in terms of
the biomass versus number of individuals.}

\item{title}{A string of the report title.}

\item{date}{A date of the report date.}

\item{file}{A string of the path to the file (without the extension).}

\item{binwidth}{A positive integer of the width of the bins for grouping.}

\item{type}{A string indicating whether to include 'both' or just the
'actual' or 'optimal' yield.}

\item{object}{The population or populations.}

\item{...}{Unused parameters.}

\item{expand}{A flag specifying whether to expand parameter combinations.}

\item{view}{A flag specifying whether to view the report (after rendering it
to html).}

\item{ask}{A flag specifying whether to ask before overwriting or creating a
file.}

\item{description}{A string describing the population.}

\item{age}{A numeric vector of the age (yr).}

\item{length}{A numeric vector of the length (cm).}

\item{names}{A character vector of unique ecotype names.}

\item{x}{The object to coerce.}
}
\description{
Parameter Descriptions for ypr Functions
}
\keyword{internal}
