% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zcta.R
\name{get_zctas_by_county}
\alias{get_zctas_by_county}
\title{Return the ZCTAs in a vector of counties}
\usage{
get_zctas_by_county(counties)
}
\arguments{
\item{counties}{A vector of Counties. Must be by FIPS code (numeric or
character).}
}
\value{
A vector, where each element is a ZCTA in the requested county.
}
\description{
Given a vector of counties, return the ZIP Code Tabulation Areas (ZCTAs)
in those counties. Note counties must be identified by FIPS code (character
or numeric) in this function because county names are not unique between states.
For example, 30 states have a county named "Washington".
}
\examples{
# "06075" is San Francisco County, California
get_zctas_by_county("06075")

# 6075 (== as.numeric("06075")) works too
get_zctas_by_county(6075)

# Multiple counties at the same time are also OK
get_zctas_by_county(c("06075", "36059"))

}
