% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipfpoylogVariance.R
\name{zipfpoylogVariance}
\alias{zipfpoylogVariance}
\title{Variance of the ZipfPolylog distribution.}
\usage{
zipfpoylogVariance(alpha, beta, tolerance = 10^(-4))
}
\arguments{
\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 3}).}

\item{beta}{Value of the \eqn{\beta} parameter (\eqn{\beta \in (-\infty, +\infty)}).}

\item{tolerance}{Tolerance used in the calculations. (default = \eqn{10^{-4}})}
}
\value{
A positive real value corresponding to the variance of the distribution.
}
\description{
Computes the variance of the ZipfPolylog distribution for given values of \eqn{\alpha} and \eqn{\beta}.
}
\details{
The variance of the distribution only exists for \eqn{\alpha} strictly greater than 3.
}
\examples{
zipfpoylogVariance(0.5, 0.75)
}
\seealso{
\code{\link{zipfpolylogMoments}}, \code{\link{zipfpolylogMean}}.
}
