% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelled_light.R
\name{ll_labelled}
\alias{ll_labelled}
\title{Create a labelled variable}
\usage{
ll_labelled(x = double(), labels = NULL, label = NULL)
}
\arguments{
\item{x}{A vector to label. Must be either numeric (integer or double) or
character.}

\item{labels}{A named vector or \code{NULL}. The vector should be the same type
as \code{x}. Unlike factors, labels don't need to be exhaustive: only a fraction
of the values might be labelled.}

\item{label}{A short, human-readable description of the vector.}
}
\value{
A valid labelled variable.
}
\description{
The labelled_light (ll) collection is a minimal implementation of core
functions for creating and managing \code{haven_labelled} variables, and with
minimal dependencies. These functions, prefixed with \code{ll_} rely only on base
R, and operate only on objects of type \code{haven_labelled}. All functions check
internally that the variables have the correct class and the correct
structure for labelled variables, satisfying the (minimal) specification
inherent in the parameter documentation of the \code{\link[haven:labelled]{haven::labelled()}} function.

The constructor, \code{ll_labelled()}, creates a labelled variable satisfying that
specification.
}
\seealso{
Other labelled light: 
\code{\link{ll_assert_labelled}()},
\code{\link{ll_to_character}()},
\code{\link{ll_val_labels}()},
\code{\link{ll_var_label}()},
\code{\link{threadbare}()}
}
\concept{labelled light}
\keyword{internal}
